-- =========================================
-- DATABASE KOPERASI
-- =========================================
CREATE DATABASE IF NOT EXISTS koperasi_db;
USE koperasi_db;

-- =========================================
-- TABEL USERS (LOGIN)
-- =========================================
CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    nama VARCHAR(100),
    role ENUM('admin','petugas','anggota') NOT NULL,
    anggota_id INT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- =========================================
-- TABEL ANGGOTA
-- =========================================
CREATE TABLE anggota (
    id INT AUTO_INCREMENT PRIMARY KEY,
    no_anggota VARCHAR(30) UNIQUE NOT NULL,
    nama VARCHAR(100) NOT NULL,
    alamat TEXT,
    no_hp VARCHAR(20),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- =========================================
-- TABEL SIMPANAN
-- =========================================
CREATE TABLE simpanan (
    id INT AUTO_INCREMENT PRIMARY KEY,
    anggota_id INT NOT NULL,
    jenis ENUM('pokok','wajib','sukarela') NOT NULL,
    jumlah DECIMAL(15,2) NOT NULL,
    tanggal DATE NOT NULL,
    keterangan TEXT,
    FOREIGN KEY (anggota_id) REFERENCES anggota(id) ON DELETE CASCADE
);

-- =========================================
-- TABEL PINJAMAN
-- =========================================
CREATE TABLE pinjaman (
    id INT AUTO_INCREMENT PRIMARY KEY,
    anggota_id INT NOT NULL,
    jumlah DECIMAL(15,2) NOT NULL,
    tenor INT NOT NULL,
    bunga DECIMAL(5,2),
    status ENUM('pengajuan','disetujui','ditolak','lunas') DEFAULT 'pengajuan',
    tanggal_pengajuan DATE,
    FOREIGN KEY (anggota_id) REFERENCES anggota(id)
);

-- =========================================
-- TABEL ANGSURAN
-- =========================================
CREATE TABLE angsuran (
    id INT AUTO_INCREMENT PRIMARY KEY,
    pinjaman_id INT NOT NULL,
    jumlah DECIMAL(15,2),
    tanggal DATE,
    FOREIGN KEY (pinjaman_id) REFERENCES pinjaman(id) ON DELETE CASCADE
);

-- =========================================
-- TABEL KAS
-- =========================================
CREATE TABLE kas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    tanggal DATE,
    masuk DECIMAL(15,2) DEFAULT 0,
    keluar DECIMAL(15,2) DEFAULT 0,
    keterangan TEXT
);

-- =========================================
-- TABEL INVENTORY
-- =========================================
CREATE TABLE inventory (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nama_barang VARCHAR(100),
    stok INT DEFAULT 0,
    harga DECIMAL(15,2)
);

-- =========================================
-- TABEL TRANSAKSI INVENTORY
-- =========================================
CREATE TABLE inventory_transaksi (
    id INT AUTO_INCREMENT PRIMARY KEY,
    inventory_id INT,
    jenis ENUM('masuk','keluar'),
    jumlah INT,
    tanggal DATE,
    FOREIGN KEY (inventory_id) REFERENCES inventory(id)
);

-- =========================================
-- TABEL SHU
-- =========================================
CREATE TABLE shu (
    id INT AUTO_INCREMENT PRIMARY KEY,
    anggota_id INT,
    tahun INT,
    jumlah DECIMAL(15,2),
    FOREIGN KEY (anggota_id) REFERENCES anggota(id)
);

-- =========================================
-- USER DEFAULT (ADMIN)
-- =========================================
INSERT INTO users (username, password, nama, role)
VALUES (
    'admin',
    SHA2('admin123',256),
    'Administrator',
    'admin'
);
